/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.python.core.io.BufferedWriter;
import org.python.core.io.RawIOBase;

public class LineBufferedWriter
extends BufferedWriter {
    public LineBufferedWriter(RawIOBase rawIOBase) {
        super(rawIOBase, 0);
        this.buffer = ByteBuffer.allocate(8192);
    }

    public int write(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            try {
                this.buffer.put(by);
            }
            catch (BufferOverflowException bufferOverflowException) {
                this.flush();
                this.buffer.put(by);
            }
            if (by != 10) continue;
            this.flush();
        }
        return n;
    }
}

